UNIT EPHMERIS;
{1) calculates the position of all planets and moon in radialen}
   {all planets takes on pentium 100 about 5 mSec}
{2  Calculates julian date}
{3) conversion between az,alt to ra,dec and back}

{(*  Converted to TurboC from BASIC program EPHM2.BAS, originally written by}
{David Bulger by:  David A. Beisel [70277,3600] (compuserve)*)}
{converted to pascal by Han Kleijn, han_kleijn@compuserve.com, diameter data added, modified to unit }

{The accuracy is not so good for outer planets Uranus, Neptune and Pluto !!}

{original converted for "hallo northern sky program", but no longer used after 98-4-12}

{added alt-az ra-dec calculatians}
{added julian date}
{han Kleijn}

Interface

var  ra,          {ra in radialen}
     dcr,         {dec in radialen}
     r,           {distance from earth in AE}
     mag          {magnitude, in case moon % iluminated}

                 : double;
     name        : string[10];
  diameter       : real;    {Diameter in arcsec}

  azimuth2       : double;
  altitude2      : double;
  ra_jupiter, diameter_jupiter,mag_jupiter,
  dcr_jupiter                              : double;


PROCEDURE SUN(julian:double); {julian is julian date, e.g. at 1.1.1998 at 22:00 hour, julian date is 2450815.41667}
PROCEDURE MERCURY(julian:double);
PROCEDURE VENUS(julian:double);
PROCEDURE MOON(julian:double);
PROCEDURE MARS(julian:double);
PROCEDURE JUPITER(julian:double);
PROCEDURE jovianmoon(julian:double); {nr is moon number, based on meeus, 1979 }
procedure jovian(nr :integer);
PROCEDURE SATURN(julian:double);
PROCEDURE NEPTUNE(julian:double);
PROCEDURE URANUS(julian:double);
PROCEDURE PLUTO(julian:double);

function JULIAN2(yyyy,mm,dd,hours,minutes,seconds:real):real; {##### calculate julian date}

PROCEDURE AZ_RA(AZ,ALT,LAT,LONG,t:double);{conversion az,alt to ra,dec}
{input AZ [0..2pi], ALT [-pi/2..+pi/2],lat[-90..90],long[0..360],time[0..2*pi]}

PROCEDURE RA_AZ(RA,dec,LAT,LONG,t:double);{conversion ra & dec to altitude, azimuth}
{input RA [0..2pi], DEC [-pi/2..+pi/2],lat[-90..90],long[0..360],time[0..2*pi]}

PROCEDURE PARALLAX(WTIME:REAL;longitude,latitude : real);{calculates parallax after calling first planet}
Implementation


(****************** Global Variables ********************)

const p2=pi*2;
      EPOCH: double = 2415020;

var
  outfiles: text;
  filename: text;

  p , mag1 ,mag2 ,mag3 ,mag4 , xsol ,ysol ,zsol ,solrad ,oblq,
  eccent ,mean ,ea1 ,ma ,ma1 ,ma2 ,v0 ,  a ,e ,i ,u ,w: double ;
  jov_x,jov_y,jov_mag              :array[1..4] of real;{for jovian moons}

function tan(x:double):double;
begin
  tan:=sin(x)/cos(x);
end;

Function LeadingZero(w : integer) : String;
 var
   s : String;
 begin
   Str(w:0,s);
   if Length(s) = 1 then
     s := '0' + s;
   LeadingZero := s;
 end;

procedure prepare_ra(rax:double); {radialen to text}
 var
   s : String[6];
 begin {make from rax [0..pi*2] a text in array bericht. Length is 6 long}
  Str(trunc((0.0021817+rax)*12/(pi)):7,s);
  write(s+':'+leadingzero(trunc(6000*(frac((0.0021817+rax)*12/pi)))));
 {note 0.0021817 is half minute to get rounding and not 7:60 results as with round}
end;
procedure prepare_dec(decx:real); {radialen to text}
 var
   s : String[6];
 begin {make from rax [0..pi*2] a text in array bericht. Length is 6 long}
  if decx>0 then
  begin
     Str(trunc((0.0001454+decx)*180/(pi)):7,s);
     writeln('  ',s+'d '+leadingzero(trunc(6000*abs(frac((+0.0001454+decx)*180/pi)))));
  end
  else
  begin
    Str(trunc((-0.0001454+decx)*180/(pi)):5,s);
    writeln('  ',s+'d '+leadingzero(trunc(6000*abs(frac((-0.0001454+decx)*180/pi)))));
  end;
 {note 0.0001454 is half minute DEC!! to get rounding and not 7:60 results as with round}
end;

{(********************************************************)}
function JULIAN2(yyyy,mm,dd,hours,minutes,seconds:real):real; {##### calculate julian date}
var y,m,secday,psecday,partday,a,jd :real;
begin

  IF MM>2 THEN  begin Y:=YYYY; M:=MM;end
  else  IF ((MM=1) OR (MM=2)) THEN begin Y:=YYYY-1; M:=MM+12;end;

  SECDAY := 86400;
  PSECDAY:=(HOURS*60*60)+(MINUTES*60)+SECONDS;
  PARTDAY:=PSECDAY/SECDAY;
  Jd:=INT(365.25*Y)+INT(30.6001*(M+1))+(DD+PARTDAY)+1720994.5 ;
  IF (YYYY >=1582.1015) then jd:=jd+2-INT(Y/100)+INT(INT(Y/100)/4); {year 1583}
  julian2:=jd;
end;


FUNCTION fndegrad (x:double): double;
BEGIN
  fndegrad:=(x *(PI / 180));
END;

FUNCTION fnraddeg (x:double): double;
BEGIN
  fnraddeg:=(x *(180/PI ));
END;

FUNCTION fnarccos (x:double): double;
BEGIN
  fnarccos:=(-arctan(x /sqrt(-x *x +1))+PI /2 );
END;

FUNCTION fnmodulo (x,y: double):double;
BEGIN
   FNMODULO:=Y *(X /Y -INT(X /Y ))
END;

FUNCTION fns (x:double):double;
BEGIN
  fns:=(sin(180/PI *x ));
END;

FUNCTION fnu(x:double):double;
BEGIN
  fnu:=X-(INT(X/360)*360);
END;

FUNCTION sgn (x:double):integer;
BEGIN
  if (x >= 0) then sgn:=(1) else sgn:=(-1);
END;

FUNCTION fnp (x:double):double;
BEGIN
  fnp:=SGN(X)*((ABS(X)/3600)/360-INT((ABS(X)/3600)/360))*360;
END;

FUNCTION fnacos (x:double):double;
BEGIN
  fnacos:=(-arctan(x /sqrt(-x *x +1))+PI / 2);
END;

FUNCTION fnasin (x:double):double;
BEGIN
  fnasin:=(arctan(x /sqrt(-x *x +1)));
END;

PROCEDURE  radec;
{*        Generalized Solution for RA & Dec of given Planet            * }
{'***********************************************************************}
{'------- requires inputs of: a,e,i,u,w,ea and oblq ---------------------}

Var l1 ,m1 ,n1 ,l2 ,m2 ,n2 ,p3 ,p4 ,p5 ,p6 ,b1 ,x ,y ,z ,rad,dis ,phase:double ;
BEGIN
  l1 := cos(u )*cos(w -u )-sin(u )*sin(w -u )*cos(i );
  m1 := (sin(u )*cos(w -u ))+(cos(u )*sin(w -u )*cos(i ));
  n1 := sin(w -u )*sin(i );
  l2 := -cos(u )*sin(w -u )-sin(u )*cos(w -u )*cos(i );
  m2 := -sin(u )*sin(w -u )+cos(u )*cos(w -u )*cos(i );
  n2 := cos(w -u )*sin(i );
  p3 := m1 *cos(oblq )-n1 *sin(oblq );
  p4 := m1 *sin(oblq )+n1 *cos(oblq );
  p5 := m2 *cos(oblq )-n2 *sin(oblq );
  p6 := m2 *sin(oblq )+n2 *cos(oblq );
  b1 := a *sqrt (1-e *e );
  x := a *l1 *cos(ea1 )+b1 *l2 *sin(ea1 )-a *e *l1 ;
  y := a *p3 *cos(ea1 )+b1 *p5 *sin(ea1 )-a *e *p3 ;
  z := a *p4 *cos(ea1 )+b1 *p6 *sin(ea1 )-a *e *p4 ;
  rad := sqrt(x *x +y *y +z *z );
  x := x +xsol ;
  y := y +ysol ;
  z := z +zsol ;
  ra := arctan(y /x );
  if ((x <0) AND (y >= 0)) then ra := ra +PI ;
  if ((x <0) AND (y <0)) then ra := ra +PI ;
  if ((x >0) AND (y <0)) then ra := ra +P2 ;
  {ra := ra *(180/PI );}
  {ra := ra / 15;}
  dcr := arctan(z / sqrt(x *x +y *y ));
  {dcr := dcr *(180/PI );}
  r := sqrt (x *x +y *y +z *z );
  dis := r ;
  phase := rad *rad +dis *dis -solrad *solrad ;
  phase := phase /(2*(rad *dis ));
  phase := fnacos(phase );
  phase := phase *(180/PI );
  mag1 := v0 + 5 * (ln(dis*rad) / ln(10)) + ma1*(phase-50) + ma2* ((phase-50) * (phase-50));
  mag2 := v0 + 5 * (ln(dis*rad) / ln(10)) + ma*phase + ma1 *(phase*phase*phase);
  mag3 := v0 + 5 * (ln(dis*rad) / ln(10)) + ma*phase;
  mag4 := v0 + 5 * (ln(dis*rad) / ln(10));
END;

{(***  ea  ***)}
PROCEDURE  ea;
var  e0 ,dm ,de :double ;
BEGIN
  e0 := mean +eccent *sin(mean );
  repeat
    dm := mean -(e0 -eccent *sin(e0 ));
    de := dm /(1-eccent *cos(e0 ));
    if (abs(dm )<=0.0000001) then begin ea1 := e0 ; exit; end;
    e0 := e0 +de ;
  until false
END;

{(***  Moon Elements Update ***)}
{(*  Converted to TurboC from BASIC program MOON.BAS originally written by}
{David Bulger Converted by David A. Beisel [70277,3600] *)}
{converted to Pascal by Han Kleijn}
PROCEDURE moon(julian:double);
vaR
  ajd ,im ,j ,dy ,jd ,l1 ,m0 ,esol ,lsol ,csol ,tlsol,
  solarlong ,m1 ,d0 ,f0 ,l2 ,adt1 ,adt2 ,adsin2 ,adsin3 ,adsin ,e0 ,adt3 ,adsin4 ,longt ,b ,w1 ,w2,
  l3 ,e2 ,dp0 ,qw, latt ,p ,pp0 ,pp1 ,pp2 ,obliq ,rra0 ,rra1 ,rra2 ,dc0,
  q2 ,dlun ,ilun1 ,ilun2 ,ilun0 ,illfrac ,hx ,mx ,sol2,t :double;
BEGIN
  t := (julian -EPOCH) / 36525;
  l1 := 270.434164+fnmodulo(481267.8831*t ,360)-0.001133*(t *t )+0.0000019*(t *t *t );
  l1 := fnmodulo(l1 ,360);
  m0 := 358.475833+fnmodulo(35999.04975*t ,360)-0.00015*(t *t )- 0.0000033*(t *t *t );
  m0 := fnmodulo(m0 ,360);
  lsol := 279.69668;
  sol2 := 36000.76892*t ;
  sol2 := fnmodulo(sol2 ,360);
  lsol := lsol +sol2 +0.0003025*(t *t );
  lsol := fnmodulo (lsol ,360);
  csol := 1.91946-0.004789*t -0.000014*(t *t );
  csol := fndegrad(csol )*sin(fndegrad(m0 ));
  csol := csol +(fndegrad(0.02094-0.0001*t )*sin(2*(fndegrad(m0 ))));
  csol := csol +(fndegrad(0.000293)*sin(3*fndegrad(m0 )));
  tlsol := lsol +fnraddeg(csol );
  solarlong := tlsol ;
  m1 := 296.104608+fnmodulo(477198.8491*t ,360)+0.009192*(t *t )+0.0000144*(t *t *t );
  m1 := fnmodulo(m1 ,360);
  d0 := 350.737486+fnmodulo(445267.1142*t ,360)-0.001436*(t *t )+0.0000019*(t *t *t );
  d0 := fnmodulo(d0 ,360);
  f0 := 11.250889+fnmodulo(483202.0251*t ,360)-0.003211*(t *t )-0.0000003*(t *t *t );
  f0 := fnmodulo(f0 ,360);
  l2 := 259.183275-fnmodulo(1934.142*t ,360)+0.002078*(t *t )+ 0.0000022*(t *t *t );
  l2 := fnmodulo(l2 +360,360);
  adt1 := fnmodulo(51.2+20.2*t ,360);
  adsin := sin(fndegrad(adt1 ));
  l1 := l1 +(0.000233*adsin );
  m0 := m0 -(0.001778*adsin );
  m1 := m1 +(0.000817*adsin );
  d0 := d0 +(0.002011*adsin );
  adt2 := fnmodulo (346.56+132.87*t -0.0091731*(t *t ),360);
  adsin2 := sin(fndegrad(adt2 ));
  adsin2 := 0.003964*adsin2 ;
  l1 := l1 +adsin2 ;
  m1 := m1 +adsin2 ;
  d0 := d0 +adsin2 ;
  f0 := f0 +adsin2 ;
  l3 := fndegrad(l2 );
  adsin3 := sin(l3 );
  l1 := l1 +(0.001964*adsin3 );
  m1 := m1 +(0.002541*adsin3 );
  d0 := d0 +(0.001964*adsin3 );
  f0 := f0 -(0.024691*adsin3 );
  adt3 := l2 +275.05-(2.3*t );
  adt3 := fnmodulo(adt3 ,360);
  adsin4 := sin(fndegrad(adt3 ));
  f0 := f0 -(0.004328*adsin4 );
  e0 := 1-0.002495*t -0.00000752*(t *t );
  e2 := e0 *e0 ;
{  (*******  Main longitude terms follow *********)}
  longt := l1 +6.28875*sin(fndegrad(m1 ));
  longt := longt +1.274018*sin(fndegrad(2*d0 -m1 ));
  longt := longt +0.658309*sin(fndegrad(2*d0 ));
  longt := longt +0.213616*sin(fndegrad(2*m1 ));
  longt := longt +(e0 *(-0.185596*sin(fndegrad(m0 ))));
  longt := longt -0.114336*sin(fndegrad(2*f0 ));
  longt := longt +0.058793*sin(fndegrad(2*d0 -2*m1 ));
  longt := longt +(e0 *(0.057212*sin(fndegrad(2*d0 -m0 -m1 ))));
  longt := longt +0.05332*sin(fndegrad(2*d0 +m1 ));
  longt := longt +(e0 *(0.045874*sin(fndegrad(2*d0 -m0 ))));
  longt := longt +(e0 *(0.041024*sin(fndegrad(m1 -m0 ))));
  longt := longt -0.034718*sin(fndegrad(d0 ));
  longt := longt +(e0 *(-0.030465*sin(fndegrad(m0 +m1 ))));
  longt := longt +0.015326*sin(fndegrad(2*d0 -2*f0 ));
  longt := longt -0.012528*sin(fndegrad(2*f0 +m1 ));
  longt := longt -0.01098*sin(fndegrad(2*f0 -m1 ));
  longt := longt +0.010674*sin(fndegrad(4*d0 -m1 ));
  longt := longt +0.010034*sin(fndegrad(3*m1 ));
  longt := longt +0.008548*sin(fndegrad(4*d0 -2*m1 ));
  longt := longt +(e0 *(-0.00791*sin(fndegrad(m0 -m1 +2*d0 ))));
  longt := longt +(e0 *(-0.006783*sin(fndegrad(2*d0 +m0 ))));
  longt := longt +0.005162*sin(fndegrad(m1 -d0 ));
  longt := longt +(e0 *(0.005*sin(fndegrad(m0 +d0 ))));
  longt := longt +(e0 *(0.004049*sin(fndegrad(m1 -m0 +2*d0 ))));
  longt := longt +0.003996*sin(fndegrad(2*m1 +2*d0 ));
  longt := longt +0.003862*sin(fndegrad(4*d0 ));
  longt := longt +0.003665*sin(fndegrad(2*d0 -3*m1 ));
  longt := longt +(e0 *(0.002695*sin(fndegrad(2*m1 -m0 ))));
  longt := longt +0.002602*sin(fndegrad(m1 -2*f0 -2*d0 ));
  longt := longt +(e0 *(0.002396*sin(fndegrad(2*d0 -m0 -2*m1 ))));
  longt := longt -0.002349*sin(fndegrad(m1 +d0 ));
  longt := longt +(e2 *(0.002249*sin(fndegrad(2*d0 -2*m0 ))));
  longt := longt +(e0 *(-0.002125*sin(fndegrad(2*m1 +m0 ))));
  longt := longt +(e2 *(-0.002079*sin(fndegrad(2*m0 ))));
  longt := longt +(e2 *(0.002059*sin(fndegrad(2*d0 -m1 -2*m0 ))));
  longt := longt -0.001773*sin(fndegrad(m1 +2*d0 -2*f0 ));
  longt := longt -0.001595*sin(fndegrad(2*f0 +2*d0 ));
  longt := longt +(e0 *(0.00122*sin(fndegrad(4*d0 -m0 -m1 ))));
  longt := longt -0.00111*sin(fndegrad(2*m1 +2*f0 ));
  longt := longt +0.000892*sin(fndegrad(m1 -3*d0 ));
  longt := longt +(e0 *(-0.000811*sin(fndegrad(m0 +m1 +2*d0 ))));
  longt := longt +(e0 *(0.000761*sin(fndegrad(4*d0 -m0 -2*m1 ))));
  longt := longt +(e2 *(0.000717*sin(fndegrad(m1 -2*m0 ))));
  longt := longt +(e2 *(0.000704*sin(fndegrad(m1 -2*m0 -2*d0 ))));
  longt := longt +(e0 *(0.000693*sin(fndegrad(m0 -2*m1 +2*d0 ))));
  longt := longt +(e0 *(0.000598*sin(fndegrad(2*d0 -m0 -2*f0 ))));
  longt := longt +0.00055*sin(fndegrad(m1 +4*d0 ));
  longt := longt +0.000538*sin(fndegrad(4*m1 ));
  longt := longt +(e0 *(0.000521*sin(fndegrad(4*d0 -m0 ))));
  longt := longt +0.000486*sin(fndegrad(2*m1 -d0 ));
  (****  Main lattitude terms follow ****)
  b := 5.128189*sin(fndegrad(f0 ));
  b := b +0.280606*sin(fndegrad(m1 +f0 ));
  b := b +0.277693*sin(fndegrad(m1 -f0 ));
  b := b +0.173238*sin(fndegrad(2*d0 -f0 ));
  b := b +0.055413*sin(fndegrad(2*d0 +f0 -m1 ));
  b := b +0.046272*sin(fndegrad(2*d0 -f0 -m1 ));
  b := b +0.032573*sin(fndegrad(2*d0 +f0 ));
  b := b +0.017198*sin(fndegrad(2*m1 +f0 ));
  b := b +0.009267*sin(fndegrad(2*d0 +m1 -f0 ));
  b := b +0.008823*sin(fndegrad(2*m1 -f0 ));
  b := b +(e0 *(0.008247*sin(fndegrad(2*d0 -m0 -f0 ))));
  b := b +0.004323*sin(fndegrad(2*d0 -f0 -2*m1 ));
  b := b +0.0042*sin(fndegrad(2*d0 +f0 +m1 ));
  b := b +(e0 *(0.003372*sin(fndegrad(f0 -m0 -2*d0 ))));
  b := b +(e0 *(0.002472*sin(fndegrad(2*d0 +f0 -m0 -m1 ))));
  b := b +(e0 *(0.002222*sin(fndegrad(2*d0 +f0 -m0 ))));
  b := b +(e0 *(0.002072*sin(fndegrad(2*d0 -f0 -m0 -m1 ))));
  b := b +(e0 *(0.001877*sin(fndegrad(f0 -m0 +m1 ))));
  b := b +0.001828*sin(fndegrad(4*d0 -f0 -m1 ));
  b := b +(e0 *(-0.001803*sin(fndegrad(f0 +m0 ))));
  b := b -0.00175*sin(fndegrad(3*f0 ));
  b := b +(e0 *(0.00157*sin(fndegrad(m1 -m0 -f0 ))));
  b := b -0.001487*sin(fndegrad(f0 +d0 ));
  b := b +(e0 *(-0.001481*sin(fndegrad(f0 +m0 +m1 ))));
  b := b +(e0 *(0.001417*sin(fndegrad(f0 -m0 -m1 ))));
  b := b +(e0 *(0.00135*sin(fndegrad(f0 -m0 ))));
  b := b +0.00133*sin(fndegrad(f0 -d0 ));
  b := b +0.001106*sin(fndegrad(f0 +3*m1 ));
  b := b +0.00102*sin(fndegrad(4*d0 -f0 ));
  b := b +0.000833*sin(fndegrad(f0 +4*d0 -m1 ));
  b := b +0.000781*sin(fndegrad(m1 -3*f0 ));
  b := b +0.00067*sin(fndegrad(f0 +4*d0 -2*m1 ));
  b := b +0.000606*sin(fndegrad(2*d0 -3*f0 ));
  b := b +0.000597*sin(fndegrad(2*d0 +2*m1 -f0 ));
  b := b +(e0 *(0.000492*sin(fndegrad(2*d0 +m1 -m0 -f0 ))));
  b := b +0.00045*sin(fndegrad(2*m1 -f0 -2*d0 ));
  b := b +0.000439*sin(fndegrad(3*m1 -f0 ));
  b := b +0.000423*sin(fndegrad(f0 +2*d0 +2*m1 ));
  b := b +0.000422*sin(fndegrad(2*d0 -f0 -3*m1 ));
  b := b +(e0 *(-0.000367*sin(fndegrad(m0 +f0 +2*d0 -m1 ))));
  b := b +(e0 *(-0.000353*sin(fndegrad(m0 +f0 +2*d0 ))));
  b := b +0.000331*sin(fndegrad(f0 +4*d0 ));
  b := b +(e0 *(0.000317*sin(fndegrad(2*d0 +f0 -m0 +m1 ))));
  b := b +(e2 *(0.000306*sin(fndegrad(2*d0 -2*m0 -f0 ))));
  b := b -0.000283*sin(fndegrad(m1 +3*f0 ));
  w1 := 0.0004664*(cos(fndegrad(l2 )));
  w2 := 0.0000754*(cos(fndegrad(fnmodulo(l2 +275.05-2.3*t ,360))));
  latt := b *(1-w1 -w2 );
  (*** Parallax terms follow ***)
  p := 0.950724;
  p := p +0.051818*cos(fndegrad(m1 ));
  p := p +0.009531*cos(fndegrad(2*d0 -m1 ));
  p := p +0.007843*cos(fndegrad(2*d0 ));
  p := p +0.002824*cos(fndegrad(2*m1 ));
  p := p +0.000857*cos(fndegrad(2*d0 +m1 ));
  p := p +(e0 *(0.000533*cos(fndegrad(2*d0 -m0 ))));
  p := p +(e0 *(0.000401*cos(fndegrad(2*d0 -m0 -m1 ))));
  p := p +(e0 *(0.00032*cos(fndegrad(m1 -m0 ))));
  p := p -0.000271*cos(fndegrad(d0 ));
  p := p +(e0 *(-0.000264*cos(fndegrad(m0 +m1 ))));
  p := p -0.000198*cos(fndegrad(2*f0 -m1 ));
  p := p +0.000173*cos(fndegrad(3*m1 ));
  p := p +0.000167*cos(fndegrad(4*d0 -m1 ));
  p := p +(e0 *(-0.000111*cos(fndegrad(m0 ))));
  p := p +0.000103*cos(fndegrad(4*d0 -2*m1 ));
  p := p -0.000084*cos(fndegrad(2*m1 -2*d0 ));
  p := p +(e0 *(-0.000083*cos(fndegrad(2*d0 +m0 ))));
  p := p +0.000079*cos(fndegrad(2*d0 +2*m1 ));
  p := p +0.000072*cos(fndegrad(4*d0 ));
  p := p +(e0 *(0.000064*cos(fndegrad(2*d0 -m0 +m1 ))));
  p := p +(e0 *(-0.000063*cos(fndegrad(2*d0 +m0 -m1 ))));
  p := p +(e0 *(0.000041*cos(fndegrad(m0 +d0 ))));
  p := p +(e0 *(0.000035*cos(fndegrad(2*m1 -m0 ))));
  p := p -0.000033*cos(fndegrad(3*m1 -2*d0 ));
  p := p -0.00003*cos(fndegrad(m1 +d0 ));
  p := p -0.000029*cos(fndegrad(2*f0 -2*d0 ));
  p := p +(e0 *(-0.000029*cos(fndegrad(2*m1 +m0 ))));
  p := p +(e2 *(0.000026*cos(fndegrad(2*d0 -2*m0 ))));
  p := p -0.000023*cos(fndegrad(2*f0 -2*d0 +m1 ));
  p := p +(e0 *(0.000019*cos(fndegrad(4*d0 -m0 -m1 ))));
  r := (6378.14/sin(fndegrad(p )))/149598770;
  pp0 := p *60;
  pp1 := trunc(pp0) ;
  pp0 := pp0 -pp1 ;
  (*   pp2 = pp0 * 60; *)
  (*** compute mean obliquity of ecliptic ***)
  obliq := 23.452296;
  obliq := obliq -0.0130125*t ;
  obliq := obliq -0.00000164*(t *t );
  obliq := obliq +0.000000503*(t *t *t );
  (*** conversion from ecliptical to equatorial coordinates ***)
  rra0 := sin(fndegrad(longt ))*cos(fndegrad(obliq ))-(sin(fndegrad(latt ))/cos(fndegrad(latt )))*
  sin(fndegrad(obliq ));
  rra1 := cos(fndegrad(longt ));
  rra2 := rra0 / rra1 ;
  rra2 := arctan(rra2 );
  if ((rra1 <0) AND (rra0 >= 0)) then rra2 := rra2 +PI ;
  if ((rra1 <0) AND (rra0 <0)) then rra2 := rra2 +PI ;
  if ((rra1 >= 0) AND (rra0 <0)) then rra2 := rra2 +(2*PI );
  ra := rra2 {*(12/PI )};
  dc0 := sin(fndegrad(latt ))*cos(fndegrad(obliq ))+cos(fndegrad(latt ))* sin(fndegrad(obliq ))*sin(fndegrad(longt ));
  dc0 := dc0 / sqrt (-dc0 *dc0 +1);
  dcr  := arctan(dc0 );

{  ***  calculate illuminated fraction of moon  *** }
  qw := fnmodulo(longt -solarlong ,360);
  dlun := cos(fndegrad(qw ))*cos(fndegrad(latt ));
  dlun := fnarccos(dlun );
  ilun1 := sin(fndegrad(m1 ));
  ilun1 := ilun1 *0.0549;
  ilun1 := 1-ilun1 ;
  ilun2 := sin(fndegrad(m0 ));
  ilun2 := ilun2 *0.0167;
  ilun2 := 1-ilun2 ;
  ilun0 := ilun1 / ilun2 ;
  ilun0 := ilun0 *sin(dlun );
  ilun0 := ilun0 *fndegrad(0.1468);
  ilun0 := PI -dlun -ilun0 ;
  illfrac := 1+cos(ilun0 );
  illfrac := illfrac / 2;
  illfrac := illfrac *100-0.18;
  illfrac := abs(illfrac );
  mag := illfrac ;
  name := 'MOON';
  diameter:= ((1/r)* 3476 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}
END;

{*** Solar Elements Update ***}
PROCEDURE sun(julian:double);

var
  asol ,esol ,isol ,usol ,wsol ,msol, vsol ,rsol ,rasol ,dcsol,t,t2,t3:double ;
BEGIN
  t := (julian -EPOCH) / 36525;
  t2 := t *t ;
  t3 := t *t *t ;
  asol := 1.00000003;
  esol := 1.675104E-2-0.0000418*t -1.26E-7*t2 ;
  wsol := 4.908229467+0.0300052642*t +7.902463E-6*t2 + 0.0000000058117706*t3 ;
  oblq := 0.4093197552-2.27111E-04*t -0.00000028604007*t2 +  8.775128E-6*t3 ;
  msol := 628.3019457*t ;
  msol := fnmodulo (msol ,P2 );
  msol := msol +6.256583774;
  msol := fnmodulo (msol ,P2 );
  msol := msol -2.618E-6*t2 -0.0000000581776417*t3 ;
  msol := fnmodulo (msol ,P2 );
  eccent := esol ;
  mean := msol ;
  ea;
  msol := ea1 ;
  vsol := 2*arctan(sqrt((1+esol )/(1-esol ))*sin(msol / 2)/cos(msol/2));
  rsol := asol *(1-esol *cos(msol ));
  xsol := rsol *cos(wsol +vsol );
  ysol := rsol *sin(wsol +vsol )*cos(oblq );
  zsol := rsol *sin(wsol +vsol )*sin(oblq );
  rasol := arctan(ysol / xsol );
  if ((xsol <0) AND (ysol >= 0)) then rasol := rasol +PI ;
  if ((xsol <0) AND  (ysol <0)) then rasol := rasol +PI ;
  if ((xsol >= 0) AND (ysol <0)) then rasol := rasol +P2 ;
  dcsol := arctan(zsol / sqrt(xsol *xsol +ysol *ysol ));
  mag := -27;
  ra := rasol ;
  dcr := dcsol ;
  name := 'SUN';
  r := rsol ;
  solrad := r ;
  diameter:= ((1/r)* 1392720 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}

END;

{*** Mercury Elements Update ***}
PROCEDURE mercury(julian:double);
var
  amer ,emer ,imer ,umer ,wmer ,mmer,t,t2,t3 :double ;
BEGIN

  t := (julian -EPOCH) / 36525;
  t2 := t *t ;
  t3:=t*t*t;
  amer := 0.3870986;
  emer := 0.20561421+2.046E-5*t -3E-8*t2 ;
  imer := pi*(7.010678 -0.0059556*t+0.00000069*t2-0.000000035*t3)/180 ;
  umer := pi*(48.456876-0.1254715*t -0.00008844*t2-0.000000068*t3)/180 ;
  wmer := umer + pi*(28.839814+0.2842765*t +0.00007445*t2+0.000000043*t3)/180 ;
  mmer := (pi*149472.51529/180)*t ;
  mmer := fnmodulo (mmer ,P2 );
  mmer := mmer +pi*102.27938/180;
  mmer := fnmodulo (mmer ,P2 );
  mmer := mmer +(pi*0.000007/180)*t2 ;
  mmer := fnmodulo (mmer ,P2 );
  mean:=mmer;
  eccent := emer ;
  mean := mmer ;
  ea;

  v0 := 1.16;
  ma:=0; {han modification}
  ma1 :=0.02838;
  ma2 :=0.0001023;
  mmer := ea1 ;
  a := amer ;
  e := emer ;
  i := imer ;
  u := umer ;
  w := wmer ;
  ea1 := mmer ;
  radec;
  mag := mag1 ;
  name := 'MERCURY';
  diameter:= ((1/r)* 4878 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}
END;

{*** Venus Elements Update ***}

PROCEDURE  venus(julian:double);
var aven ,even ,iven ,uven ,wven ,mven,t,t2,t3:double;
BEGIN
  t := (julian -EPOCH) / 36525;
  t2 := t *t ;
  t3:=t2*t;
  aven := 0.7233316;{alpha, semimajor axis of the orbit}
  even := 0.00682069-0.00004774*t+0.000000091*t2 ;{eccentricity of orbit}
  iven := pi*(3.395459 -0.0007913*t-0.00003250*t2  +0.000000018*t3)/180 ;{inclination of orbit for equinox 2000}
  uven := pi*(76.957740-0.2776656*t -0.00014010*t2+0.000000769*t3)/180 ;{omega, longitude of ascending node for equinox 2000}
  wven := uven + pi*(54.602827+0.2892764*t -0.00114464*t2-0.000000794*t3)/180 ;{argumunt of perihelon+ omega}
  mven := (pi*58517.80387/180)*t ;
  mven := fnmodulo (mven ,P2 );
  mven := mven +pi*212.60322/180;
  mven := fnmodulo (mven ,P2 );
  mven := mven +(pi*0.001286/180)*t2 ;
  mven := fnmodulo (mven ,P2 ); {M, anomaly for julian date 1900 Januari 0.5 ET}
  mean:=mven;
  eccent := even ;
  mean := mven ;
  ea;
  v0 := 4;
  ma :=0.01322;
  ma1 := 4.247E-7;
  mven := ea1 ;
  a := aven ;
  e := even ;
  i := iven ;
  u := uven ;
  w := wven ;
  ea1 := mven ;
  radec;
  mag := mag2 ;
  name := 'VENUS';
  diameter:= ((1/r)* 12104 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}
END;

{***  Mars Elements Update ***}

PROCEDURE mars(julian:double);

VAR amar ,emar ,imar ,umar ,wmar ,mmar,t,t2,t3 :double ;
BEGIN
  t := (julian -EPOCH) / 36525;
  t2 := t *t ;
  t3:=t2*t;

  amar := 1.5236883;{alpha, semimajor axis of the orbit}
  emar := 0.09331290+0.000092064*t -0.000000077*t2 ;{eccentricity of orbit}
  imar := pi*(1.857866-0.0081565*t-0.00002304*t2  -0.000000044*t3)/180 ;{inclination of orbit for equinox 2000}
  umar := pi*(49.852347-0.2941821*t -0.00064344*t2-0.000008159*t3)/180 ;{omega, longitude of ascending node for equinox 2000}
  wmar := umar + pi*(285.762379+0.7387251*t +0.00046556*t2+0.000006939*t3)/180 ;{argumunt of perihelon+ omega}
  mmar := (pi*19139.85475/180)*t ;
  mmar := fnmodulo (mmar ,P2 );
  mmar := mmar +pi*319.51913/180;
  mmar := fnmodulo (mmar ,P2 );
  mmar := mmar +(pi*0.000181/180)*t2 ;
  mmar := fnmodulo (mmar ,P2 ); {M, anomaly for julian date 1900 Januari 0.5 ET}
  mean:=mmar;
  eccent := emar ;
  mean := mmar ;
  ea;

  v0 := -1.3;
  ma :=0.01486;
  mmar := ea1 ;
  a := amar ;
  e := emar ;
  i := imar ;
  u := umar ;
  w := wmar ;
  ea1 := mmar ;
  radec;
  mag := mag3 ;
  name := 'MARS';
  diameter:= ((1/r)* 6796 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}
END;

{***  Jupiter Elements Update  ***}

PROCEDURE  JUPITER(JULIAN:double);

VAR t,t2,t3,ajup ,ejup ,ijup ,wjup ,ujup ,mjup:double ;
BEGIN

  t := (julian -EPOCH) / 36525;
  t2 := t *t ;
  t3:=t2*t;

  ajup := 5.202561;{alpha, semimajor axis of the orbit}
  ejup := 0.04833475+0.000164189*t -0.0000004676*t2-0.0000000017*T3 ;{eccentricity of orbit}
  ijup := pi*(1.305288 -0.0022374*t+0.00002942*t2  +0.000000127*t3)/180 ;{inclination of orbit for equinox 2000}
  ujup := pi*(100.287838+0.1659357*t +0.00096672*t2-0.000012460*t3)/180 ;{omega, longitude of ascending node for equinox 2000}
  wjup := ujup + pi*(273.829584+0.0478404*t -0.00021857*t2+0.000008999*t3)/180 ;{argumunt of perihelon+ omega}
  mjup := (pi*3034.69202/180)*t ;
  mjup := fnmodulo (mjup ,P2 );
  mjup := mjup +pi*225.32833/180;
  mjup := fnmodulo (mjup ,P2 );
  mjup := mjup -(pi*0.000722/180)*t2 ;
  mjup := fnmodulo (mjup ,P2 ); {M, anomaly for julian date 1900 Januari 0.5 ET}
  mean:=mjup;
  eccent := ejup ;
  mean := mjup ;
  ea;

  v0 := -8.93;
  mjup := ea1 ;
  a := ajup ;
  e := ejup ;
  i := ijup ;
  u := ujup ;
  w := wjup ;
  ea1 := mjup ;
  radec;
  mag := mag4 ;
  name := 'JUPITER';
  diameter:= ((1/r)* 142796 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}
  ra_jupiter:=ra; {for jovian moons later}
  dcr_jupiter:=dcr;
  diameter_jupiter:=diameter;
  mag_jupiter:=mag;
END;


{***  Saturn Elements Update  ***}
PROCEDURE saturn(julian:double);
VAR t,t2,t3 ,asat ,esat ,isat ,usat ,wsat ,msat: double ;
BEGIN
  t := (julian -EPOCH) / 36525;
  t2 := t *t ;
  t3:=t2*t;

   asat:= 9.554747;{alpha, semimajor axis of the orbit}
  esat:= 0.05589232-0.00034550*t - 0.000000728*t2+   0.00000000074*T3 ;{eccentricity of orbit}
  isat:= pi*(2.486204 +0.0024449*t - 0.00005017*t2 + 0.000000002*t3)/180 ;{inclination of orbit for equinox 2000}
  usat := pi*(113.923406-0.2599254*t-0.00018997*t2-0.000001589*t3)/180 ;{omega,longitude of ascending node for equinox 2000}
  wsat := usat + pi*(338.571353+0.8220515*t +0.00070747*t2+0.000006177*t3)/180 ;{argumunt of perihelon+ omega}
  msat := (pi*1221.55147/180)*t ;
  msat := fnmodulo (msat ,P2 );
  msat := msat +pi*175.46622/180;
  msat := fnmodulo (msat ,P2 );
  msat := msat -(pi*0.000502/180)*t2 ;
  msat := fnmodulo (msat ,P2 ); {M, anomaly for julian date 1900 Januari 0.5 ET}
  mean:=msat;
  eccent := esat ;
  mean := msat ;
  ea;
  v0 := -8.68;
  msat := ea1 ;
  a := asat ;
  e := esat ;
  i := isat ;
  u := usat ;
  w := wsat ;
  ea1 := msat ;
  radec;
  mag := mag4 ;
  name := 'SATURN';
  diameter:= ((1/r)* 120660 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}

END;


{***  Uranus Elements Update  ***}

PROCEDURE  uranus(julian:double);
VAR d2 ,aura ,eura ,iura ,uura ,wura ,mura:double ;
BEGIN
  d2 := julian -2445920.5;
  aura := 19.30476-0.0000388*d2 ;
  eura :=0.04786-3.592E-6*d2 ;
  iura :=0.01351670238+1.65809E-8*d2 ;
  uura := 1.292529756-5.232E-8*d2 ;
  wura := 3.098400987-0.000014652015*d2 ;
  mura :=0.00022372245*d2 ;
  mura := fnmodulo (mura ,P2 );
  mura := mura +1.218463219;
  mura := fnmodulo (mura ,P2 );
  eccent := eura ;
  mean := mura ;
  ea;
  v0 := -6.85;
  ma := 0;
  mura := ea1 ;
  a := aura ;
  e := eura ;
  i := iura ;
  u := uura ;
  w := wura ;
  ea1 := mura ;
  radec;
  mag := mag4 ;
  name := 'URANUS';
  diameter:= ((1/r)* 51120 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}

END;

{***  Neptune Elements Update  ***}

PROCEDURE  neptune(julian:double);
VAR d2 ,anep ,enep ,inep ,unep ,wnep ,mnep :double ;
BEGIN
  d2 := julian -2445920.5;
  anep := 30.2846+6.05E-6*d2 ;
  enep :=0.0063043+3.7765E-6*d2 ;
  inep :=0.03088499734-4.27603E-8*d2 ;
  unep := 2.300171164+1.23922E-06*d2 ;
  wnep := 6.170873363+0.000047734765*d2 ;
  wnep := fnmodulo (wnep ,P2 );
  mnep :=0.000063052645*d2 ;
  mnep := fnmodulo (mnep ,P2 );
  mnep := mnep +4.846539519;
  mnep := fnmodulo (mnep ,P2 );
  eccent := enep ;
  mean := mnep ;
  ea;
  v0 := -7.05;
  ma := 0;
  mnep := ea1 ;
  a := anep ;
  e := enep ;
  i := inep ;
  u := unep ;
  w := wnep ;
  ea1 := mnep ;
  radec;
  mag := mag4 ;
  name := 'NEPTUNE';
  diameter:= ((1/r)* 49520 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}

END;

{***  Pluto Elements Update  ***}
PROCEDURE  pluto(julian:double);
Var d2 ,aplu ,eplu ,iplu ,uplu ,wplu ,mplu :double;
BEGIN

    d2 := julian - 2445920.5;
    aplu := 39.74674 -0.000342 * d2;
    eplu := 0.2539553 - 5.974E-6 * d2;
    iplu := 0.2989981134 - 5.7593E-8 * d2;
    uplu := 1.927194303 + 1.090865E-06 * d2;
    wplu := 3.916583414 + 1.430297E-05 * d2;
    mplu := 5.829138E-5 * d2;
    mplu := fnmodulo (mplu, P2);
    mplu := mplu + 6.150615326;
    mplu := fnmodulo (mplu, P2);
    eccent := eplu;
    mean := mplu;
    ea;
    v0 := -0.97;
    mplu := ea1;
    a := aplu;
    e := eplu;
    i := iplu;
    u := uplu;
    w := wplu;
    ea1 := mplu;
    radec;
    mag := mag4;
    name := 'PLUTO';
    diameter:= ((1/r)* 2280 * (360*60*60/ (p2*149.6E6))); {ae is 149.6E6 km}
END;

PROCEDURE RA_AZ(RA,dec,LAT,LONG,t:double);{conversion ra & dec to altitude, azimuth}
{input RA [0..2pi], DEC [-pi/2..+pi/2],lat[-90..90],long[0..360],time[0..2*pi]}
var t5,c1,c2,s1,s2 :double;
begin
  LAT:=pi*LAT/180;
  LONG:=pi*LONG/180;
  T5:=T-RA+LONG;
  {***** altitude calculation *******}
  S1:=SIN(LAT)*SIN(DEC)+COS(LAT)*COS(DEC)*COS(T5);
  C1:=1-(S1*S1);
  IF C1>0 THEN begin C1:=SQRT(C1); altitude2:=ArcTaN(S1/C1);end
  else
  begin if s1>0 then altitude2:=pi/2 else altitude2:=-pi/2; end;
  {***** azimuth calculation ******}
  C2:=COS(LAT)*SIN(DEC)-SIN(LAT)*COS(DEC)*COS(T5);
  S2:=-COS(DEC)*SIN(T5);
  IF C2=0 THEN begin if s2<0 then AZIMUTH2:=-pi/2 else AZIMUTH2:=pi/2; end
  else
  begin AZIMUTH2:=Arctan(S2/C2); IF C2<0 THEN AZIMUTH2:=AZIMUTH2+Pi; end;
  IF AZIMUTH2<0 THEN AZIMUTH2:=AZIMUTH2+2*Pi;
  {output altitude=H  in radialen ,   azimuth=A in radialen}
  {write(RA:3:2,'    ',dec:3:2,' ==> ','ALTITUDE: ',(ALTITUDE):3:2,'  AZIMUTH:  ',AZIMUTH:3:2);}
end;
PROCEDURE AZ_RA(AZ,ALT,LAT,LONG,t:double);{conversion az,alt to ra,dec}
{input AZ [0..2pi], ALT [-pi/2..+pi/2],lat[-90..90],long[0..360],time[0..2*pi]}
var
  sindec,cosra : double;
begin
  LAT:=pi*LAT/180;
  {***** dec calculation ******}
  sindec:=sin(alt)*sin(lat) + cos(alt)*cos(az)*cos(lat); {=sin(dec)}
  if abs(sindec)<1 then begin  dcr:=ARCTAN(sindec/(SQRT(1-SQR(sindec))));end {arcsin function}
  else
  begin if sindec>0 then
                    dcr:=pi/2 {note bij x=1 klapt uitkomst net naar 0}
                    else dcr:=-pi/2;
  end;  {arcsin function}
  {***** ra calculation *******}
  cosra:=(sin(alt)*cos(lat)-cos(alt)*cos(az)*sin(lat))/cos(dcr);
  if ABS(cosra)<1 then begin RA:=(PI/2-ARCTAN(cosra/(SQRT(1-SQR(cosra))))) end {arccos function}
  else
  begin if cosra>0 then RA:=0 {note bij x=1 klapt uitkomst net om}
                   else RA:=PI;
  end; {arccos function}
  if az>pi then ra:=2*pi-ra;
  ra:=ra+long*pi/180 +t;
  while ra<0 do ra:=ra+2*pi;
  while ra>=2*pi do ra:=ra-2*pi;
 { writeln(' dcr: ',dcr:4:2, ' ra: ',ra:4:2);}
end;

PROCEDURE PARALLAX(WTIME:REAL;longitude,latitude : real); { By Han Kleijn}
{wtime= Sidereal time at greenwich - longitude, equals position of the sky for the observer.
                                                Is function of daytime, day, and longitude}
var HP,                {equatorial horizontal parrallax}
    d_ra,
    H          {geocentric hour angle}
      :double;

BEGin
{based of formula from MEEUS 1979}

{following improvements are not used}
{flatteningearth:=0.99664719;} {earth is not perfect round}
{sin_latitude_corrected:=flatteningearth*sin(arctan(flatteningearth*tan(latitude)))+height_above_sea*sin(latitude)/6378140;}
{cos_latitude_corrected:=cos(arctan(flatteningearth*tan(latitude)))+height_above_sea*cos(latitude)/6378140;}
{above values are very close to sin(latitude) and cos(latitude)}

 HP:=(6378.16/(r*149.6E6)); {r in AE, HP is equatorial horizontal parallex}

 H:=wtime-RA; {geocentric hour angle. =Sidereal time at greenwich - longitude - RA. in our case longitude is already in wtime}

 d_ra:=arctan((- cos(latitude)*HP * sin(H))/(cos(dcr)- cos(latitude)* HP* cos(H)));
 dcr:=arctan((sin(dcr)- sin(latitude)*HP )*cos(d_ra)/(cos(dcr)- cos(latitude)*HP*cos(H)));

 ra:=ra+d_ra; {watch out d_ra is used in above DCR calculation}
end;

{***  Jovian moon  ***}
PROCEDURE  jovianmoonold(julian:double;nr:integer); {based on meeus, 1979 }
Var M,N,J,D,A,B,K,delta,psi,X :double;
BEGIN

    D := julian - 2415020;

    M:=fnmodulo((358.476 + 0.9856003*D)*(pi/180),P2); {fnmodulo is reduce to 0..2*pi}
    N:=fnmodulo((225.328 + 0.0830853*D)*(pi/180),P2);
    J:=fnmodulo((221.647 + 0.9025179*D)*(pi/180),P2);
    A:=1.92*(pi/180)*sin(M) + 0.02*(pi/180)*sin(2*M);
    B:=5.537*(pi/180)*sin(N) + 0.167*(pi/180)*sin(2*N);
    K:=J + A - B;
    delta:=sqrt(28.07-10.406*cos(K));
    psi:=arctan(sin(K)/sqrt(sqr(delta)-sqr(sin(k))));
    case nr of
               1: begin
                    U:=fnmodulo((84.5506 + 203.4058630*(D-delta/173))*pi/180 + psi -B,P2);
                    X:=0.5* 5.906*sin(U);
                    name := 'I';
                    diameter:= diameter_jupiter * 3630/142796;{only correct if jupiter routine was called previously}
                    mag:=mag_jupiter+7.5;
                  end;
               2: begin
                    U:=fnmodulo((41.5015 + 101.2916323*(D-delta/173))*pi/180 + psi -B,P2);
                    X:=0.5*9.397*sin(U);
                    name := 'II';
                    diameter:= diameter_jupiter *3138/142796 ;{only correct if jupiter routine was called previously}
                    mag:=mag_jupiter+7.8;
                  end;
               3: begin
                    U:=fnmodulo((109.9770 + 050.2345169*(D-delta/173))*pi/180 + psi -B,P2);
                    X:=0.5*14.989*sin(U);
                    name := 'III';
                    diameter:= diameter_jupiter * 5262/142796;{only correct if jupiter routine was called previously}
                    mag:=mag_jupiter+7.1;
                  end;
               4: begin
                    U:=fnmodulo((176.3586 + 021.4879802*(D-delta/173))*pi/180 + psi -B,P2);
                    X:=0.5*26.364*sin(U);
                    name := 'IV';
                    diameter:= diameter_jupiter * 4800/142796;{only correct if jupiter routine was called previously}
                    mag:=mag_jupiter+8.1;
                   end;
               end;
    if ((abs(X)<=0.5) and (abs(U-pi)<1)) then mag:=99; {behind jupiter}
    {x is (seen) distance from jupiter centrum and u is rotation angle. U should be close to pi}
    {factor x is the distance from jupiter in jupiter diameters}
    ra:=ra_jupiter + x *diameter_jupiter*P2/(360*3600); {only correct if jupiter routine was called previously}
END;
PROCEDURE jovianmoon(julian:double); {based on meeus, 1979 and 'Par Pierre Arpin BSc.'}
     function sinus(x:real):real;
     begin
       sinus:=sin(x*pi/180);
     end;
     function cosin(x:real):real;
     begin
       cosin:=cos(x*pi/180);
     end;
{    FUNCTION DELTA_T(X:INTEGER):REAL;}
{      VAR T : REAL;}
{      BEGIN}
{      IF ANNEE<1903 THEN  {ANNEE IS YEAR}
{      BEGIN}
{         T:=(ANNEE-1903)/100;}
{         DELTA_T:=(0.41+1.2053*T+0.4992*T*T)*60;}
{      END}
{      ELSE  DELTA_T:=0.6*(ANNEE-1903);}
{    END;}

VAR     U,COR,RR                      : ARRAY[1..4] OF REAL;
        DELT,AA,BB                    : REAL;
        M,N,J,K,V,C2,RRR,G,H {,C1}    : REAL;
        D1,R_R,JR,psi,SINPSI          : REAL;
        LLAM,DS,Q,DE,D,X_X,D_T        : REAL;
        PP                            : STRING;
        I                             : INTEGER;
        X,Y                           :REAL;
        { LAM                         : ARRAY[1..2] OF REAL;} {position of jupiter meridans I and II}


BEGIN
D1:=julian-2415020;
V:=134.63+0.00111587*D1;
M:=fnmodulo((358.476+0.9856003*D1),360);
N:=fnmodulo((225.328+0.0830853*D1+0.33*SINUS(V)),360);
J:=fnmodulo((221.647+0.9025179*D1-0.33*SINUS(V)),360);
AA:=1.916*SINUS(M)+0.02*SINUS(2*M);
BB:=5.552*SINUS(N)+0.0167*SINUS(2*N);
K:=J+AA-BB;
R_R:=1.0014-0.01672*COSIN(M)-0.00014*COSIN(2*M);
RRR:=5.20867-0.25192*COSIN(N)-0.0061*COSIN(2*N);
DELT:=SQRT(SQR(RRR)+2*SQR(R_R)-2*RRR*R_R*COSIN(K));
SINPSI:=R_R/DELT*SINUS(K);
PSI:=(180/pi)* fnasin(SINPSI);

X_X:=(D1-DELT/173);
{LAM[1]:=fnmodulo((268.28+877.8169088*X_X)+PSI-BB,360);}
{LAM[2]:=fnmodulo((290.28+870.1869088*X_X)+PSI-BB,360);}
{C1:=0.01016*DELTA_T(ANNEE);}
{C2:=0.01007*DELTA_T(ANNEE);}
{LAM[1]:=fnmodulo((LAM[1]+C1),360);}
{LAM[2]:=fnmodulo((LAM[2]+C2),360);}
LLAM:=fnmodulo((238.05+0.083091*D1+0.033*SINUS(V)+BB),360);
DS:=3.07*SINUS(LLAM+44.5);
Q:=(RRR-DELT)/DELT;
DE:=DS-2.15*SINUS(PSI)*COSIN(LLAM+24)-1.3*Q*SINUS(LLAM-99.4);
U[1]:=fnmodulo((84.5506+203.4058683*X_X)+PSI-BB,360);
U[2]:=fnmodulo((41.5015+101.2916323*X_X)+PSI-BB,360);
U[3]:=fnmodulo((109.977+50.2345169*X_X)+PSI-BB,360);
U[4]:=fnmodulo((176.3586+21.4879802*X_X)+PSI-BB,360);
G:=fnmodulo((187.3+50.310674*X_X),360);
H:=fnmodulo((311.1+21.569229*X_X),360);
COR[1]:=0.472*SINUS(2*(U[1]-U[2]));
COR[2]:=1.073*SINUS(2*(U[2]-U[3]));
COR[3]:=0.174*SINUS(G);
COR[4]:=0.845*SINUS(H);
FOR I:=1 TO 4 DO
   U[I]:=U[I]+COR[I];
RR[1]:=5.9061-0.0244*COSIN(2*(U[1]-U[2]));
RR[2]:=9.397199-0.0889*COSIN(2*(U[2]-U[3]));
RR[3]:=14.9894-0.0227*COSIN(G);
RR[4]:=26.3649-0.1944*COSIN(H);

jov_mag[1]:=mag_jupiter+7.5;
jov_mag[2]:=mag_jupiter+7.8;
jov_mag[3]:=mag_jupiter+7.1;
jov_mag[4]:=mag_jupiter+8.1;


FOR I:=1 TO 4 DO
   BEGIN
     jov_X[I]:=(RR[I]*SINUS(U[I]));{distance in jupiter radius}
     jov_Y[i]:=-(RR[I]*COSIN(U[I])*SINUS(DE));{height in jupiter radius. minus is above}

     if ( (sqr(jov_X[i])+(sqr(jov_Y[i]))<=1) and (abs(U[i]-180)<90)) then jov_mag[i]:=999; {behind jupiter}
   end;

END;
PROCEDURE jovian(nr:integer);
begin
    case nr of
               1: begin
                    name := 'I';
                    diameter:= diameter_jupiter * 3630/142796;{only correct if jupiter routine was called previously}
                  end;
               2: begin
                    name := 'II';
                    diameter:= diameter_jupiter *3138/142796 ;{only correct if jupiter routine was called previously}
                  end;
               3: begin
                    name := 'III';
                    diameter:= diameter_jupiter * 5262/142796;{only correct if jupiter routine was called previously}
                  end;
               4: begin
                    name := 'IV';
                    diameter:= diameter_jupiter * 4800/142796;{only correct if jupiter routine was called previously}
                   end;
               end;

  ra:=ra_jupiter + 0.5*jov_x[nr] *diameter_jupiter*P2/(360*3600); {only correct if jupiter routine was called previously}
  dcr:=dcr_jupiter + 0.5*jov_y[nr] *diameter_jupiter*P2/(360*3600);
  mag:=jov_mag[nr];
{  diameter:=diameter*3;}

end;

begin
end.
