10 '**************************************************************************
20 '*                       EPHMERIS.BAS Version 2.0.0                       *
30 '**************************************************************************
40 DEFDBL A-Z
50 BLANK$=STRING$(20,32)
60 DEF FNMODULO (X ,Y )=Y *(X /Y -INT(X /Y ))
70 DEF FNBLANK$(A$)=RIGHT$(BLANK$,15-LEN(A$))
80 DEF FNS(X)=SIN(180/PI*X)
90 DEF FNU(X)=X-(INT(X/360)*360)
100 DEF FNP(X)=SGN(X)*((ABS(X)/3600)/360-INT((ABS(X)/3600)/360))*360
110 DEF FNACOS(X)=-ATN(X/SQR(-X*X+1))+PI/2
120 DEF FNASIN(X)=ATN(X/SQR(-X*X+1))
130 PI =3.141592653589793# :P2 =PI *2 
140 EPOCH =2415020! :REM = January 0.0, 1900
150 CLS
160 FOR N%=1 TO 7:PRINT:NEXT N%
170 PRINT"                           Single-date Ephemeris"
180 PRINT
190 PRINT"                               Version 2.0.2"
200 PRINT
210 PRINT"                                Authored by:"
220 PRINT
230 PRINT"                          David A. Bulger (c) 1987"
240 PRINT
250 PRINT"                             All rights reserved"
260 GOSUB 2830
270 CLS
280 '------------------ Gregorian input to Julian -----------------------------
290 INPUT"Month";MONTH
300 IF MONTH<>INT(MONTH) OR MONTH<0 OR MONTH >12 THEN 290
310 INPUT"Day";DAY
320 IF DAY<>INT(DAY) OR DAY<0 OR DAY>31 THEN 310
330 INPUT"Year (eg:1987)";YEAR
340 'Gregorian error check (do not allow dates between 1582.1005 and 1582.1015)
350 YJT#=YEAR+MONTH/100+DAY/10000:IF YJT#<1582.1005# THEN GREG=0
360 IF (YJT#>=1582.1005#)AND(YJT#<1582.1015#) THEN GREGERR=1 ELSE GREGERR=0
370 IF YJT#>=1582.1015# THEN GREG=1
380 CLS
390 IF GREGERR THEN PRINT"Impossible date; try again":GOTO 290
400 INPUT"Hour (GMT)";HOUR
410 IF HOUR<0 OR HOUR<>INT(HOUR) OR HOUR>24 THEN 400
420 INPUT"Minute";MINUTE
430 IF MINUTE<>INT(MINUTE) OR MINUTE<0 OR MINUTE>59 THEN 420
440 INPUT"Second";SECOND
450 IF SECOND<0 OR SECOND>60 THEN 440
460 CLS:INPUT"Do you want a printout of results";YN$
470 CLS
480 IF LEFT$(YN$,1)="Y" OR LEFT$(YN$,1)="y" THEN PRN=1 ELSE PRN=0
490 IM =12*(YEAR+4800)+MONTH-3:J =(2*(IM -INT(IM /12)*12)+7+365*IM )/12
500 J =INT(J )+DAY+INT(IM /48)-32083
510 JULIAN =J +INT(IM /4800)-INT(IM /1200)+37.5
520 JULIAN =JULIAN +(HOUR+MINUTE/60+SECOND/3600)/24
530 HOUR=HOUR+MINUTE/60+SECOND/3600
540 T =JULIAN -EPOCH :T =T /36525!:T2 =T *T :T3 =T *T *T 
550 '**************************************************************************
560 '*                          Solar Elements Update                         *
570 '**************************************************************************
580 ASOL =1.00000003# 
590 ESOL =1.675104E-02-.0000418*T -1.26E-07*T2 
600 ISOL =0
610 USOL =0
620 WSOL =4.908229467# +.0300052642# *T +7.902463E-06 *T2 +.0000000058117706# *T3 
630 OBLQ =.4093197552# -2.27111E-04*T -.00000028604007# *T2 +8.775128E-06 *T3 
640 MSOL =628.3019457# *T :MSOL =FNMODULO (MSOL ,P2 )
650 MSOL =MSOL +6.256583774# :MSOL =FNMODULO (MSOL ,P2 )
660 MSOL =MSOL -2.618E-06*T2 -.0000000581776417# *T3 :MSOL =FNMODULO (MSOL ,P2 )
670 ECCENT=ESOL :MEAN=MSOL :GOSUB 2330:MSOL =EA
680 VSOL=2*ATN(SQR((1+ESOL )/(1-ESOL ))*TAN(MSOL /2))
690 RSOL =ASOL *(1-ESOL *COS(MSOL ))
700 XSOL =RSOL *COS(WSOL +VSOL )
710 YSOL =RSOL *SIN(WSOL +VSOL )*COS(OBLQ )
720 ZSOL =RSOL *SIN(WSOL +VSOL )*SIN(OBLQ )
730 RASOL =ATN(YSOL /XSOL )
740 IF XSOL <0  AND YSOL >=0  THEN RASOL =RASOL +PI 
750 IF XSOL <0  AND YSOL <0  THEN RASOL =RASOL +PI 
760 IF XSOL >=0  AND YSOL <0  THEN RASOL =RASOL +P2 
770 RASOL =RASOL *(180 /PI ):RASOL =RASOL /15 
780 DCSOL =ATN(ZSOL /SQR(XSOL *XSOL +YSOL *YSOL ))
790 DCSOL =DCSOL *(180 /PI )
800 MAG=-27
810 RA =RASOL :DC =DCSOL :O$="Sun":R =RSOL:SOLRAD=R:GOSUB 2090:GOSUB 2230
820 '**************************************************************************
830 '*                     Mercury Elements Update                            *
840 '**************************************************************************
850 AMER=.3870986
860 EMER=.20561421#+2.046E-05*T-3E-08*T2
870 IMER=.1222233228#+3.244777E-05*T-3.2E-07*T2
880 UMER=.8228519595#+.0206857877#*T+3.0349E-06*T2
890 WMER=1.324699618#+.0271484026#*T+5.1439E-06*T2
900 MMER=2608.787533013#*T:MMER=FNMODULO#(MMER,P2)
910 MMER=MMER+1.7851119476#:MMER=FNMODULO#(MMER,P2)
920 MMER=MMER+1.16355E-07*T2:MMER=FNMODULO#(MMER,P2)
930 ECCENT=EMER:MEAN=MMER:GOSUB 2330
940 V0=1.16:MA1=.02838:MA2=.0001023
950 MMER=EA:A=AMER:E=EMER:I=IMER:U=UMER:W=WMER:EA=MMER:GOSUB 2390
960 MAG=MAG1
970 O$="Mercury":GOSUB 2230
980 '*************************************************************************
990 '*                       Venus Elements Update                           *
1000 '*************************************************************************
1010 AVEN=.7233316
1020 EVEN=6.82069E-03-4.774E-05*T+9.099999E-08*T2
1030 IVEN=.0592300268#+1.7555E-05*T-1.69685E-09*T2
1040 UVEN=1.32260435#+.0157053453#*T+.0000071558499#*T2
1050 WVEN=2.271787459#+.0245748661#*T-1.70412E-05*T2
1060 MVEN=1021.328349#*T:MVEN=FNMODULO(MVEN,P2)
1070 MVEN=MVEN+3.7106261796#:MVEN=FNMODULO(MVEN,P2)
1080 MVEN=MVEN+2.24459E-05*T2:MVEN=FNMODULO(MVEN,P2)
1090 ECCENT=EVEN:MEAN=MVEN:GOSUB 2330
1100 V0=4!:MA=.01322:MA1=4.247E-07
1110 MVEN=EA:A=AVEN:E=EVEN:I=IVEN:U=UVEN:W=WVEN:EA=MVEN:GOSUB 2390
1120 MAG=MAG2
1130 O$="Venus":GOSUB 2230
1140 '*************************************************************************
1150 '                      Mars Elements Update                             *
1160 '************************************************************************
1170 AMAR=1.5236915#
1180 EMAR=9.331289E-02+9.2064E-05*T-7.7E-08*T2
1190 IMAR=.0322944089#-1.1781E-05*T+2.2105E-07*T2
1200 UMAR=.8514840374#+.0134563431#*T-.000000024240684#*T2-9.31E-08*T3
1210 WMAR=5.833208059#+.0321272937#*T+2.266504E-06*T2-2.0847E-08*T3
1220 MMAR=334.0535492#*T:MMAR=FNMODULO(MMAR,P2)
1230 MMAR=MMAR+5.576840523#:MMZR=FNMODULO(MMAR,P2)
1240 MMAR=MMAR+3.1557E-06*T2:MMAR=FNMODULO(MMAR,P2)
1250 MMAR=MMAR+.000000020846988#*T3:MMAR=FNMODULO(MMAR,P2)
1260 ECCENT=EMAR:MEAN=MMAR:GOSUB 2330
1270 V0=-1.3:MA=.01486
1280 MMAR=EA:A=AMAR:E=EMAR:I=IMAR:U=UMAR:W=WMAR:EA=MMAR:GOSUB 2390
1290 MAG=MAG3
1300 O$="Mars":GOSUB 2230
1310 '************************************************************************
1320 '*                    Jupiter Elements Update                           *
1330 '************************************************************************
1340 D2=JULIAN-2445920.5#
1350 AJUP=5.202743-6.75E-07*D2
1360 EJUP=.0480453+1.17E-07*D2
1370 IJUP=.022770962#-5.2357E-07*D2
1380 WJUP=.272271363#+2.33874E-06*D2
1390 UJUP=1.7511935#+.0000785398144#*D2
1400 MJUP=.0014480674#*D2:MJUP=FNMODULO(MJUP,P2)
1410 MJUP=MJUP+4.73761928#:MJUP=FNMODULO(MJUP,P2)
1420 ECCENT=EJUP:MEAN=MJUP:GOSUB 2330
1430 V0=-8.93
1440 MJUP=EA:A=AJUP:E=EJUP:I=IJUP:U=UJUP:W=WJUP:EA=MJUP:GOSUB 2390
1450 MAG=MAG4
1460 O$="Jupiter":GOSUB 2230
1470 '************************************************************************
1480 '*                    Saturn Elements Update                            *
1490 '************************************************************************
1500 ASAT=9.567498-1.927E-05*D2
1510 ESAT=.0507778-3.8E-07*D2
1520 ISAT=.043364974#-6.1083E-09*D2
1530 USAT=1.984622617#+4.27635E-07*D2
1540 WSAT=1.640340714#-5.427098E-05*D2
1550 MSAT=.00063947206#*D2:MSAT=FNMODULO(MSAT,P2)
1560 MSAT=MSAT+2.232414341#:MSAT=FNMODULO(MSAT,P2)
1570 ECCENT=ESAT:MEAN=MSAT:GOSUB 2330
1580 V0=-8.68
1590 MSAT=EA:A=ASAT:E=ESAT:I=ISAT:U=USAT:W=WSAT:EA=MSAT:GOSUB 2390
1600 MAG=MAG4
1610 O$="Saturn":GOSUB 2230
1620 '***********************************************************************
1630 '*                     Uranus Elements Update                          *
1640 '***********************************************************************
1650 AURA=19.30476-.0000388*D2
1660 EURA=.04786-3.592E-06*D2
1670 IURA=.01351670238#+1.65809E-08*D2
1680 UURA=1.292529756#-5.232E-08*D2
1690 WURA=3.098400987#-.000014652015#*D2
1700 MURA=.00022372245#*D2:MURA=FNMODULO(MURA,P2)
1710 MURA=MURA+1.218463219#:MURA=FNMODULO(MURA,P2)
1720 ECCENT=EURA:MEAN=MURA:GOSUB 2330
1730 V0=-6.85:MA=0
1740 MURA=EA:A=AURA:E=EURA:I=IURA:U=UURA:W=WURA:EA=MURA:GOSUB 2390
1750 MAG=MAG4
1760 O$="Uranus":GOSUB 2230
1770 '*********************************************************************
1780 '*                    Neptune Elements Update                        *
1790 '*********************************************************************
1800 ANEP=30.2846+6.05E-06*D2
1810 ENEP=.0063043+3.7765E-06*D2
1820 INEP=.03088499734#-4.27603E-08*D2
1830 UNEP=2.300171164#+1.23922E-06*D2
1840 WNEP=6.170873363#+.000047734765#*D2
1850 WNEP=FNMODULO(WNEP,P2)
1860 MNEP=.000063052645#*D2:MNEP=FNMODULO(MNEP,P2)
1870 MNEP=MNEP+4.846539519#:MNEP=FNMODULO(MNEP,P2)
1880 ECCENT=ENEP:MEAN=MNEP:GOSUB 2330
1890 V0=-7.05:MA=0
1900 MNEP=EA:A=ANEP:E=ENEP:I=INEP:U=UNEP:W=WNEP:EA=MNEP:GOSUB 2390
1910 MAG=MAG4
1920 O$="Neptune":GOSUB 2230
1930 '***********************************************************************
1940 '*                      Pluto Elements Update                          *
1950 '***********************************************************************
1960 APLU=39.74674-.000342*D2
1970 EPLU=.2539553-5.974E-06*D2
1980 IPLU=.2989981134#-5.7593E-08*D2
1990 UPLU=1.927194303#+1.090865E-06*D2
2000 WPLU=3.916583414#+1.430297E-05*D2
2010 MPLU=5.829138E-05*D2:MPLU=FNMODULO(MPLU,P2)
2020 MPLU=MPLU+6.150615326#:MPLU=FNMODULO(MPLU,P2)
2030 ECCENT=EPLU:MEAN=MPLU:GOSUB 2330
2040 V0=-.97
2050 MPLU=EA:A=APLU:E=EPLU:I=IPLU:U=UPLU:W=WPLU:EA=MPLU:GOSUB 2390
2060 MAG=MAG4
2070 O$="Pluto":GOSUB 2230
2080 GOSUB 2770
2090 REM----------------------Page Heading-----------------------
2100 IF PRN=1 THEN LPRINT"Date of calculation=";MONTH;"/";DAY;"/";YEAR;" = Julian date:";JULIAN
2110 IF PRN=1 THEN LPRINT"at ";HOUR;" Hours (GMT)":LPRINT
2120 IF PRN=1 THEN LPRINT"Object              Right                        Distance"
2130 IF PRN=1 THEN LPRINT"Name                Ascension    Declination     from Earth     Magnitude"
2140 IF PRN=1 THEN LPRINT
2150 PRINT"Date of calculation=";MONTH;"/";DAY;"/";YEAR;" = Julian date:";JULIAN 
2160 PRINT"at ";HOUR;" Hours (GMT)"
2170 PRINT
2180 PRINT"Object              Right                        Distance"
2190 PRINT"Name                Ascension    Declination     from Earth    Magnitude"
2200 PRINT
2210 RETURN
2220 STOP
2230 REM --------------------Print out section---------------------
2240 RA1=INT(RA):DC1=INT(DC)
2250 RA=RA-RA1:DC=DC-DC1:RA=RA*60:DC=DC*60
2260 RA2=INT(ABS(RA)):DC2=INT(ABS(DC))
2270 RA=RA-INT(RA):DC=DC-INT(DC):RA=RA*60:DC=DC*60
2280 RA3=ABS(RA):DC3=ABS(DC)
2290 O$=O$+FNBLANK$(O$)
2300 PRINT USING "&     ##h##'##.##  +####'##.## ##.#########     +##.##";O$,RA1,RA2,RA3,DC1,DC2,DC3,R,MAG
2310 IF PRN=1 THEN LPRINT USING"&     ##h##'##.##  +##d##'##.## ##.########     +##.##";O$,RA1,RA2,RA3,DC1,DC2,DC3,R,MAG
2320 RETURN
2330 E0=MEAN+ECCENT*SIN(MEAN)
2340 DM=MEAN-(E0-ECCENT*SIN(E0))
2350 DE=DM/(1-ECCENT*COS(E0))
2360 IF ABS(DM)<=.0000001# THEN 2380
2370 E0=E0+DE:GOTO 2340
2380 EA=E0:RETURN
2390 '***********************************************************************
2400 '*        Generalized Solution for RA & Dec of given Planet            *
2410 '***********************************************************************
2420 '------- requires inputs of: a,e,i,u,w,ea and oblq ---------------------
2430 '
2440 L1=COS(U)*COS(W-U)-SIN(U)*SIN(W-U)*COS(I)
2450 M1=SIN(U)*COS(W-U)+COS(U)*SIN(W-U)*COS(I)
2460 N1=SIN(W-U)*SIN(I)
2470 L2=-COS(U)*SIN(W-U)-SIN(U)*COS(W-U)*COS(I)
2480 M2=-SIN(U)*SIN(W-U)+COS(U)*COS(W-U)*COS(I)
2490 N2=COS(W-U)*SIN(I)
2500 P3=M1*COS(OBLQ)-N1*SIN(OBLQ)
2510 P4=M1*SIN(OBLQ)+N1*COS(OBLQ)
2520 P5=M2*COS(OBLQ)-N2*SIN(OBLQ)
2530 P6=M2*SIN(OBLQ)+N2*COS(OBLQ)
2540 B1=A*SQR(1-E*E)
2550 X=A*L1*COS(EA)+B1*L2*SIN(EA)-A*E*L1
2560 Y=A*P3*COS(EA)+B1*P5*SIN(EA)-A*E*P3
2570 Z=A*P4*COS(EA)+B1*P6*SIN(EA)-A*E*P4
2580 RAD=SQR(X*X+Y*Y+Z*Z)
2590 X=X+XSOL:Y=Y+YSOL:Z=Z+ZSOL
2600 RA=ATN(Y/X)
2610 IF X<0 AND Y>=0 THEN RA=RA+PI
2620 IF X<0 AND Y<0 THEN RA=RA+PI
2630 IF X>0 AND Y<0 THEN RA=RA+P2
2640 RA=RA*(180/PI):RA=RA/15
2650 DC=ATN(Z/SQR(X*X+Y*Y))
2660 DC=DC*(180/PI)
2670 R=SQR(X*X+Y*Y+Z*Z)
2680 DIS=R
2690 PHASE=RAD*RAD+DIS*DIS-SOLRAD*SOLRAD
2700 PHASE=PHASE/(2*(RAD*DIS))
2710 PHASE=FNACOS(PHASE):PHASE=PHASE*(180/PI)
2720 MAG1=V0+5*(LOG(DIS*RAD)/LOG(10))+MA1*(PHASE-50)+MA2*((PHASE-50)*(PHASE-50))
2730 MAG2=V0+5*(LOG(DIS*RAD)/LOG(10))+MA*PHASE+MA1*(PHASE*PHASE*PHASE)
2740 MAG4=V0+5*(LOG(DIS*RAD)/LOG(10))
2750 MAG3=V0+5*(LOG(DIS*RAD)/LOG(10))+MA*PHASE
2760 RETURN
2770 MES$="Press ESCAPE KEY to end program, any other key to continue"
2780 LOCATE 25,40-(LEN(MES$)/2)
2790 PRINT MES$;
2800 WX$=INKEY$:IF WX$="" THEN 2800
2810 IF WX$=CHR$(27) THEN CLS:END
2820 CLS:GOTO 290
2830 MES$="Press any key to continue"
2840 LOCATE 25,40-(LEN(MES$)/2)
2850 PRINT MES$;
2860 WX$=INKEY$:IF WX$="" THEN 2860
2870 RETURN
